%% Description
% Plots figure 9a: the exponential decay of the dimensionless adhesion 
% force to its equilibrium value in the non-contacting case.
%
% Compares the dynamics to a linear stability analysis when H_\infty = 5
% and \Gamma takes the values 10, 20, 40

%% Parameter Definitions
%
% G     Values of \Gamma.
%
% F     The adhesion force as calculated by the dynamical numerics
%
% t     The time of the corresponding adhesion force
%
% f     The equilibrium value of the adhesion force for each G
%
% s     The exponent calculated from a linear stability analysis:
%                   f - F = A exp(s*t) for some A
%
% col   Colour scheme for plot

clear all;close all;

%% Load data
load('figure9a.mat')

%% Plotting
% Start by plotting dynamical results
col = ['b' 'r' 'g'];
for i=1:3
   semilogy(t(:,i),f(i)-F(:,i),'color',col(i)), hold on 
   label(i,:) = ['\Gamma = ' num2str(G(i))];
end

% Add linear stability results
for i=1:3
   plot(t(:,i),(f(i)-F(end,i)).*exp(s(i).*(t(:,i)-t(end,i))),'color',...
       col(i),'linestyle','--','handlevisibility','off'), hold on 
end

% Add legend, axis labels, etc
legend(label)
xlabel('$t$','interpreter','latex')
ylabel('$F_\infty-F(t)$','interpreter','latex')
axis([0 1e-3 1e-5 1e0])

% Increase axis label size
set(findobj('type','axes'),'fontsize',20,'linewidth',2)

% Increase tick length
set(gca,'TickLength',2*get(gca,'TickLength'))
